
!"Pocket Smalltalk fileout - 20:11:31, 17. bezna 2000"!


!GeosMetaObject class methodsFor: 'demo'!

smalltalkBooleanGroup: aText
	| result gbgDialog gbg |
	
	self newObjBlock.
	
	PstPrimary addUsable: (gbgDialog := GenInteraction new
		giiVisibility: ##GIV_DIALOG;
		giiType: ##GIT_PROPERTIES;
		giiAttrs: (##GIA_INITIATED_VIA_USER_DO_DIALOG bitOr: ##GIA_MODAL);
		
		addUsable: ( ComplexMoniker new
			complexMoniker: GenInteraction; setVariant;
			cmiTopText: (aText copyToLMem: ObjBlock);
			cmiFontSize: ##FOAM_NORMAL_FONT_SIZE;
			hintDrawInBox;
			hintDrawShadow;
			hintPlaceMonikerAbove;
			hintPlaceMonikerToLeft;
			hintExpandHeightToFitParent;
			hintFixedSize: [:csha | csha cshaWidth: (##SST_PIXELS bitOr: ##FOAM_DEFAULT_COMPONENT_WIDTH)];
			hintComplexMonikerDrawSeparator;
			
			addUsable: ( gbg := GenBooleanGroup new
				gbgiSelectedBooleans: 1 + 8;
				visMonikerWithText: 'USS Enterprise Control Panel';
				hintCenterChildrenOnMonikers;
				hintIndentChildren: (##SST_PIXELS + 20);
				
				addUsable: (GenBoolean new visMonikerWithText: 'Warp drive'; gbiIdentifier: 16r01);
				addUsable: (GenBoolean new visMonikerWithText: 'Cloaking'; gbiIdentifier: 16r02);
				addUsable: (GenBoolean new visMonikerWithText: 'Shields' ; gbiIdentifier: 16r04);
				addUsable: (GenBoolean new visMonikerWithText: 'Short range scan'; gbiIdentifier: 16r08);
				addUsable: (GenBoolean new visMonikerWithText: 'Long range scan'; gbiIdentifier: 16r10)
			);
			addUsable: ( ComplexMoniker triggerSlot: 3 text: ##CMT_CLOSE command: ##IC_OK )
		)
	).
		

	self unlockObjBlock.
	
	gbgDialog doDialog.
	result := gbg booleanGroupGetSelectedBooleans.
	gbgDialog destroyDialog.

	^result
! !


!GeosMetaObject class methodsFor: 'demo'!

smalltalkDialog: aText withText: oldText
	| dlg text result |
	
	self newObjBlock.

	PstPrimary addFirstUsable: ( dlg := GenInteraction new
		giiType: ##GIT_MULTIPLE_RESPONSE;
		giiVisibility: ##GIV_DIALOG;
		giiAttrs: (##GIA_MODAL bitOr: ##GIA_INITIATED_VIA_USER_DO_DIALOG);
		
		addFirstUsable: ( ComplexMoniker new
			complexMoniker: GenInteraction; setVariant;
			cmiTopText: (aText copyToLMem: ObjBlock);
			attrComplexMonikerPlaceBitmapAtLeft;
			hintDrawInBox;
			hintComplexMonikerDrawSeparator;
			hintDrawShadow;
			hintPlaceMonikerAbove;
			hintPlaceMonikerToLeft;
			hintExpandHeightToFitParent;
			hintFixedSize: [:csha | csha cshaWidth: (##SST_PIXELS bitOr: ##FOAM_DEFAULT_COMPONENT_WIDTH)];
			hintIndentChildren: 0;
			
			addFirstUsable: ( ComplexMoniker triggerSlot: 0 text: ##CMT_OK command: ##IC_OK );

			addFirstUsable: ( text := GenText new
				gen: VisText;
				gtxiText: (oldText copyToLMem: ObjBlock);
				hintExpandWidthToFitParent;
				hintExpandHeightToFitParent;
				hintDefaultFocus
			)
		)
	).
		
	self unlockObjBlock.
	
	dlg doDialog.
	result := text textGetAll.
	dlg destroyDialog.

	^result! !


!Smalltalk class methodsFor: 'startup'!

start
	"Put your startup code here!!"
	Geos
		showText: 'My IMEI is ', Geos getImei, '.'; cr;
		showText: 'Free memory: ', Smalltalk freeMemory printString, '.'; cr;
		showText: (GeosMetaObject smalltalkDialog: 'Smalltalk generated dynamic dialog' withText: 'Edit this text.'); cr;
		showText: (GeosMetaObject smalltalkBooleanGroup: 'Smalltalk BooleanGroup') printString; cr;
		showText: (GeosMetaObject smalltalkItemGroup: 'Smalltalk Item Group') printString; cr.
	Q geosDemo.! !


!GeosMetaObject class methodsFor: 'demo'!

smalltalkItemGroup: aText
	| result gigDialog gig1 gig2 |
	

	self newObjBlock.
	
	GenInteractionSmalltalk initialize.

	PstPrimary addUsable: (gigDialog := GenInteractionSmalltalk new
		giiVisibility: ##GIV_DIALOG;
		giiType: ##GIT_PROPERTIES;
		giiAttrs: (##GIA_NOT_USER_INITIATABLE bitOr: ##GIA_MODAL);
	
		addUsable: ( ComplexMoniker new
			complexMoniker: GenInteraction; setVariant;
			cmiTopText: (aText copyToLMem: ObjBlock);
			cmiFontSize: ##FOAM_NORMAL_FONT_SIZE;
			hintDrawInBox;
			hintDrawShadow;
			hintPlaceMonikerAbove;
			hintPlaceMonikerToLeft;
			hintExpandHeightToFitParent;
			hintFixedSize: [:csha | csha cshaWidth: (##SST_PIXELS bitOr: ##FOAM_DEFAULT_COMPONENT_WIDTH)];
			hintComplexMonikerDrawSeparator;
			hintCenterChildrenOnMonikers;
		
			addUsable: ( GenInteraction new
				visMonikerWithText: 'Level: ';
				
				addUsable: ( gig1 := ComplexMoniker new
					complexMoniker: GenItemGroup; setVariant; initNextLevel;
					cmiTopText: ('Choose a level' copyToLMem: ObjBlock);
					cmiFontSize: ##FOAM_NORMAL_FONT_SIZE;
					gigiSelection: 0;
					gigiNumSelections: 1;
					
					attrGenSendApplyMsgOnApplyEvenIfNotModified;
					hintIndentChildren: (##SST_PIXELS + 20);
					
					addUsable: ( ComplexMoniker itemId: 0 text: 'Off' );
					addUsable: ( ComplexMoniker itemId: 1 text: 'Low' );
					addUsable: ( ComplexMoniker itemId: 2 text: 'Medium' );
					addUsable: ( ComplexMoniker itemId: 3 text: 'High' )
				)
			);
	
			addUsable: ( GenInteraction new
				visMonikerWithText: 'Agreement: ';
				
				addUsable: ( gig2 := ComplexMoniker new
					complexMoniker: GenItemGroup; setVariant; initNextLevel;
					cmiTopText: ('Choose an agreement level' copyToLMem: ObjBlock);
					cmiFontSize: ##FOAM_NORMAL_FONT_SIZE;
					gigiSelection: 1;
					gigiNumSelections: 1;
					
					attrGenSendApplyMsgOnApplyEvenIfNotModified;
					hintIndentChildren: (##SST_PIXELS + 20); 
					
					addUsable: ( ComplexMoniker itemId: 0 text: 'Strongly disagree' );
					addUsable: ( ComplexMoniker itemId: 1 text: 'Disagree' );
					addUsable: ( ComplexMoniker itemId: 2 text: 'No opinion' );
					addUsable: ( ComplexMoniker itemId: 3 text: 'Agree' );
					addUsable: ( ComplexMoniker itemId: 4 text: 'Strongly Agree' )
				)
			)
		)
	).
	
	self unlockObjBlock.
	gigDialog runDialog.
	result := OrderedCollection with: gig1 itemGroupGetSelection with: gig2 itemGroupGetSelection.
	gigDialog destroyAndFreeBlock.
	^result! !


